@extends('layouts.app')

@section('content')
    <!-- Main Content -->
    <div class="py-8 sm:py-12 md:py-16 bg-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center">
                <div class="max-w-md mx-auto">
                    <div class="text-center mb-8">
                        <div class="w-16 h-16 bg-[#192D50] rounded-full flex items-center justify-center mx-auto mb-4">
                            <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                                </path>
                            </svg>
                        </div>
                        <h3 class="text-xl sm:text-2xl font-bold text-gray-900 mb-2">Hasil MCU Perusahaan</h3>
                        <p class="text-gray-600">Masuk untuk mengakses data karyawan dan hasil MCU</p>
                    </div>

                    <form method="POST" action="{{ route('mcu.company.login') }}" class="space-y-6">
                        @csrf

                        <div>
                            <label for="code" class="block text-sm font-medium text-gray-700 mb-2">Kode
                                Perusahaan</label>
                            <input type="text" id="code" name="code" value="{{ old('code') }}" required
                                autofocus
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                            @error('code')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="password" class="block text-sm font-medium text-gray-700 mb-2">Password</label>
                            <input type="password" id="password" name="password" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                            @error('password')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="flex items-center justify-end">
                            <button type="submit"
                                class="bg-[#192D50] text-white px-6 py-3 rounded-none font-semibold hover:bg-[#192D50] transition duration-150">
                                Cari
                            </button>
                        </div>
                    </form>

                    <div class="mt-6 text-center">
                        <p class="text-sm text-gray-600">
                            Belum punya akses?
                            <a href="#" class="text-[#CBB4B0] hover:text-[#CBB4B0]">Hubungi Administrator</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
